// Copyright (c) 2001 Hursh Jain (http://www.mollypages.org) 
// The Molly framework is freely distributable under the terms of an
// MIT-style license. For details, see the molly pages web site at:
// http://www.mollypages.org/. Use, modify, have fun !

package fc.io.fileselectors;

import java.io.*;
import java.util.*;

/**
Filters a list of files lesser or equal to some specified size.
Negative values or a zero size value chooses <b>all</b> files. Note: 
file sizes are only applicable to normal files, <b>not</b> directories.
(a java.io.File api restriction). If the target file is a directory,
this selector always returns <b>true</b>.

@author hursh jain
@date 	3/24/2002
**/	 	
	
public class MaxSizeSelector extends ChainedFileSelector 
{
long filesize;
/** 
@param filesize		the required file size in bytes
*/
public MaxSizeSelector(long filesize) { 
	this(filesize, null);
	}

/** 
@param	filesize	the required file size in bytes
@param	filter		the next filter in the chain
*/
public MaxSizeSelector(long filesize, ChainedFileSelector filter) { 
	super(filter);
	this.filesize = filesize;
	}

protected boolean thisfilter(File name) {	
	if ( name.isDirectory() ) return true;
	if ( name.length() <= filesize ) return true; 
	//System.out.println("rejecting: " + name + ", size = " + name.length());
	return false;
	}
	
public static void main(String[] args) throws Exception
	{
	new Test();
	}

/**
Unit Test History 	
<pre>
Class Version	Tester	Status		Notes
1.0				hj		passed	
</pre>
*/
static private class Test {
Test() throws Exception
	{
	File startdir = new File("c:\\temp");
	ChainedFileSelector sel = new MaxSizeSelector(4);
	File[] files = startdir.listFiles(sel);
	List list = Arrays.asList(files);			
	System.out.println("total="+ list.size() + ", files=" + list);
	}
}	//~class Test

}