// Copyright (c) 2001 Hursh Jain (http://www.mollypages.org) 
// The Molly framework is freely distributable under the terms of an
// MIT-style license. For details, see the molly pages web site at:
// http://www.mollypages.org/. Use, modify, have fun !

package fc.io.fileselectors;

import java.io.*;
import java.util.*;

/**
Filters a list of files based on the specified suffix. To choose all
files, specify a empty string as the suffix.
<p>
The specified pattern should be an file extension, or a comma
delimited set of file extensions. For example:
<blockquote>
<pre>
gif
.gif
gif,.jpg,jpeg
</pre>
</blockquote>
Note: The '.' preceding the extension is optional: both <tt>gif</tt> and 
<tt>.gif</tt> are allowed in the specified pattern.

@author hursh jain
@date 	3/24/2002
**/	 	
public class SuffixSelector extends ChainedFileSelector 
{
List matchlist;

public SuffixSelector(String pattern) {
	this(pattern, null);
	}
	
public SuffixSelector(String pattern, ChainedFileSelector filter) {
	super(filter);
	matchlist = new ArrayList();
	if (pattern.equals("")) { 
		matchlist.add("");
		}
	else {
		StringTokenizer tok = new StringTokenizer(pattern, ",");
		while ( tok.hasMoreTokens()) {
			matchlist.add(tok.nextToken());
			}
		}
	//System.out.println("matchlist=" + matchlist);
	}

protected boolean thisfilter(File name) {	
	String filename = name.toString();
	Iterator it = matchlist.listIterator(); 
	while (it.hasNext()) { 
		String pat = (String) it.next();
		if (filename.endsWith(pat)) return true;
		}
	return false;
	}

public static void main(String[] args) throws Exception
	{
	new Test();
	}

/**
Unit Test History 	
<pre>
Class Version	Tester	Status		Notes
1.0				hj		passed	
</pre>
*/
static private class Test {
Test() throws Exception
	{
	File startdir = new File("c:\\temp");
	//File startdir = new File("C:\\web\\sites\\in-production-$web$sites\\ktres\\docs\\Prof.Treseder.UPLOAD\\photos\\Chile");	
	ChainedFileSelector sel = new SuffixSelector(".jpg", new NormalFileSelector());
	File[] files = startdir.listFiles(sel);
	List list = Arrays.asList(files);			
	System.out.println("total="+ list.size() + ", files=" + list);
	
	//empty suffix
	sel = new SuffixSelector("");
	files = startdir.listFiles(sel);
	list = Arrays.asList(files);			
	System.out.println("total="+ list.size() + ", files=" + list);
	
	}
}	//~class Test

}
