// Copyright (c) 2001 Hursh Jain (http://www.mollypages.org) 
// The Molly framework is freely distributable under the terms of an
// MIT-style license. For details, see the molly pages web site at:
// http://www.mollypages.org/. Use, modify, have fun !

package fc.io;

import fc.app.*;
import java.io.*;

/**	
A default implementation of Logger that logs all messages to the 
local <tt>System.out</tt>. 

@author hursh jain 
@version 1.2 1/5/2002
*/
public class DefaultLogger extends Logger
{
/** Constructs class with the default destination to System.out
 */
public DefaultLogger() 
	{ 
	super("Default Logger", true); 
	}

protected OutputStream getStdOutStream() {
	return System.out;
	}
	
protected OutputStream getStdErrStream() {
	return System.err;
	}
	
protected OutputStream getDebugStream() {
	return System.out;
	}

public static void main(String[] args)
	{
	new Test();
	}

/**	
Unit Test History 	
<pre>
Class Version	Tester	Status		Notes
1.1				hj		passed		
</pre>
**/	
static private class Test 
{
Test() 
	{
	System.out.println("Starting test..");
	Thread thread = Thread.currentThread();

	//final DefaultLogger df = new DefaultLogger();
	Logger df =  App.logger();

	System.out.println("Logger.toString(): " + df);
	
	df.log("message 1");
	df.log(new Object(), "message 2");
	df.stderr(this,thread,"message 3");
	
	System.out.println("adding filters...");
	df.addFilterForAll("classinfo1", new ClassInfoFilter());
	df.addFilterForAll("threadinfo1",new ThreadInfoFilter());
	df.addFilterForAll("timestamp1",new TimeStampFilter());
	System.out.println("the following messages should have filter info prepended");

	df.startDebug(true);
	System.out.println("testing level 1");
	df.setLevelForAll(Logger.Level.one);
	df.log(this,thread,"this should print");
	df.bug(this,thread,"this should print");
	df.bug2(this,thread,"this should not print");
	df.bug3(this,thread,"this should not print");
	df.flushAll();
	
	System.out.println("testing level 2");
	df.setLevelForAll(Logger.Level.two);
	df.log(this,thread,"this should print");
	df.bug(this,thread,"this should print");
	df.bug2(this,thread,"this should print");
	df.bug3(this,thread,"this should not print");
	df.flushAll();

	System.out.println("testing level 3");
	df.setLevelForAll(Logger.Level.three);
	df.log(this,thread,"this should print");
	df.bug(this,thread,"this should print");
	df.bug2(this,thread,"this should print");
	df.bug3(this,thread,"this should print");
	df.flushAll();
	
	System.out.println("adding a new destination in working directory (default-logger-test.txt)");
	try {
		df.addCategory("myfilelog",Logger.Level.one, 
			new BufferedOutputStream (
				new PrintStream(
					new FileOutputStream("defaultLoggerTest.txt"))));
		} 
	catch (Exception e) { e.printStackTrace(); }
   
    df.addFilterForAll("classinfo1", new ClassInfoFilter());
	df.addFilterForAll("threadinfo1",new ThreadInfoFilter());
	df.addFilterForAll("timestamp1",new TimeStampFilter());

	System.out.println("the following messages should go to both System.out and the file");
	df.log("myfilelog","test string\nhello world");
 
	int loopcount = 20000; 
    long bef = System.currentTimeMillis(); 
	for (int n = 0; n < loopcount; n++) {
		df.log("myfilelog", this, Thread.currentThread(), "doing stuff...hello !");
		}
	long after = System.currentTimeMillis(); 
	System.out.println("total loop count = " + (after - bef) + " ms");

	System.out.println("Now closing the log. A logger close exception should be thrown.");
	df.close();
	try {
	 	df.log(null, "message 1");
		} 
	catch (Exception e) { e.printStackTrace(); }	
	
	System.out.println("Logger.toString(): " + df);
	System.out.println("Finished testing...");
	}
} //~end Test


} //~DefaultLogger
