// Copyright (c) 2001 Hursh Jain (http://www.mollypages.org) 
// The Molly framework is freely distributable under the terms of an
// MIT-style license. For details, see the molly pages web site at:
// http://www.mollypages.org/. Use, modify, have fun !

package fc.io;

import java.util.logging.*;
import java.util.*;
import java.text.*;

/**
Formats logging messages 
**/
public class FCFormatter extends Formatter
{
static String newline = System.getProperty("line.separator");
    
//levels will be printed only if higher than this value 
static int levelPrintThreshold = Level.CONFIG.intValue(); 

private static ThreadLocal DateFormatThreadLocal = new 
ThreadLocal() {
    protected synchronized Object initialValue() {
   		return DateFormat.getDateInstance();
		//return new SimpleDateFormat();
   		}
     };

public String format(LogRecord rec)
	{
	StringBuffer buf = new StringBuffer(256);
	//this is fast
	//buf.append(System.currentTimeMillis());
	//also equally fast
	// new Date();

	DateFormat df = (DateFormat)DateFormatThreadLocal.get();
	buf.append("[");
	buf.append(df.format(new Date(rec.getMillis())));
	buf.append("] ");
	
	//buf.insert(0, "[" + new Date(rec.getMillis()) + "] ");

	//assumes that client will send null for either/both if necessary, this 
	//saves enormous time that would otherwise be spent examining the 
	//call stack in these methods' implementation

	String classname =  rec.getSourceClassName();
	String methodname = rec.getSourceMethodName();
	
	if (classname != null) {
		buf.append(classname);
		buf.append(" ");
		}
	if (methodname != null) {
		buf.append(methodname);
		buf.append(" ");
		}
		
	Level level = rec.getLevel();
	if (level.intValue() > levelPrintThreshold) {
		buf.append(level);
		buf.append(": ");
		}
	String msg = rec.getMessage();
	
	buf.append(msg);
	
	Throwable thrown = rec.getThrown();
	if (thrown != null) {
		buf.append(newline);
		buf.append(IOUtil.throwableToString(thrown));
		buf.append(newline);
		}
	
	//parameters can be passed in using any of the "logp" methods
	Object[] params = rec.getParameters();
	if (params != null) {
		buf.append(" ");
		for (int n = 0; n < params.length; n++) {
			buf.append(params[n].toString());
			buf.append(' ');
			}
		buf.append(" ");	
		}
	
	buf.append(newline);
	return buf.toString(); 
	}

}           //~class myformatter