// Copyright (c) 2001 Hursh Jain (http://www.mollypages.org) 
// The Molly framework is freely distributable under the terms of an
// MIT-style license. For details, see the molly pages web site at:
// http://www.mollypages.org/. Use, modify, have fun !

package fc.io;

import java.io.*;

/**
Prepends thread information.

@author 	hursh jain
@version 	1.0, 10/19/2001
@see     	fc.io.Logger
**/
public class ThreadInfoFilter implements ILogFilter
{
public void transform(Object caller, Thread callingThread, StringBuffer buf)  
	{
	if (callingThread == null)  {
		return;
		}
	StringBuffer tmp = new StringBuffer(128);
	tmp.append("[Thread " + callingThread.getName());
	tmp.append(", daemon=" + ((callingThread.isDaemon() == true) ? "yes" : "no"));
	if (callingThread.isAlive()) {
		 tmp.append(", group=");
		 tmp.append(callingThread.getThreadGroup().getName());
		} 
	tmp.append("] ");	
	buf.insert(0, tmp.toString());
	}
	
public String toString() 
	{
	return "Thread Information filter";
	}
}           //~class ThreadInfoFilter