// Copyright (c) 2001 Hursh Jain (http://www.mollypages.org) 
// The Molly framework is freely distributable under the terms of an
// MIT-style license. For details, see the molly pages web site at:
// http://www.mollypages.org/. Use, modify, have fun !

package fc.jdbc.dbo;

import java.sql.*;
import java.util.*;
import java.io.*;

import fc.io.*;
import fc.util.*;
import fc.jdbc.*;

/**
Create a table containing all JDBC/SQL types we are interested in. The
table is created using the database and jdbc url in the specified
configuration file. The "-db" flag is optional, if specified that table
is created in that catalog/schema. (Note: postgresql doesn't currently
allow us to set a db catalog, the db catalog/schema must be specified as
part of the jdbc url itself).
*/
public class CreateAllTypes
{
static DBName dbname ;
static String tablename;

public static void main(String args[]) throws Exception
	{
	String defaultTableName = "alltypes";
	
	Args myargs = new Args(args);
	myargs.setUsage("java CreateAllTypes -conf conf_file [-db db_schema] [-table table_name_to_create]");
	
	String db 		= myargs.get("db");
	String conf 	= myargs.getRequired("conf");
	tablename 		= myargs.get("table", defaultTableName);

	Log.getDefault().setLevel(SystemLog.DEBUG);	
	FilePropertyMgr fprops = new FilePropertyMgr(new File(conf));
	ConnectionMgr cmgr = new SimpleConnectionMgr(fprops);
	
	String url = fprops.get("jdbc.url");
	if (url.indexOf("postgres") != -1)
		dbname = DBName.postgres;
	else if (url.indexOf("mysql") != -1)
		dbname = DBName.mysql;
	else if (url.indexOf("oracle") != -1)
		dbname = DBName.oracle;
	else
		throw new Exception("I do not understand this database type. Only mysql/postgresql supported currently."); /*f$%# oracle*/
		
	Connection con = cmgr.getConnection();
	if (db != null)
		con.setCatalog(db);

	String sql = getSQL();
	Statement stmt = con.createStatement();
	System.out.println("Creating table..");
	int result = stmt.executeUpdate(sql);
	System.out.println("...done [success]");
	con.close();
	}

static String getSQL() 
	{
	String create = 
	"create table " + tablename + " ( ";  
	
	create += (dbname == DBName.mysql) ?
	  "id					int auto_increment, "
		:
	  "id					serial, "; 
	
	create += 
	   "smallint_val		smallint, " 
	 + "int_val				int not null, "
	 + "bigint_val			bigint, "
	 + "float_val			float(24), "
	 + "double_val			float(53), "
	 + "numeric_val			numeric(5,2), "
	 + "char_val			char(10), "
	 + "varchar_val			varchar(10), "
	 + "longvarchar_val		text, "
	 + "date_val			date, "
	 + "time_val			time, "
	 + "timestamp_val		timestamp, "
	 + "bit_val				bit, "
	 ;
	 
	create += (dbname == DBName.mysql) ?
	  ("boolean_val			bool, " 
	 + "varbinary_val		blob, ")
		:
	  ("boolean_val			boolean, " 
	 + "varbinary_val		bytea, ");
	
	if (dbname == DBName.mysql) {
	create += 
	  "json_val				json, ";
	}
	else if (dbname == DBName.postgres) {
	create += 
	  "array_val			varchar(10)[], "
	+ "json_val				json, "
	+ "jsonb_val			jsonb, ";
	}

	create += " PRIMARY KEY (id) )";
	
	return create;
	}
	
}