// Copyright (c) 2001 Hursh Jain (http://www.mollypages.org) 
// The Molly framework is freely distributable under the terms of an
// MIT-style license. For details, see the molly pages web site at:
// http://www.mollypages.org/. Use, modify, have fun !

package fc.jdbc.dbo;

import java.io.*;
import java.sql.*;
import java.util.*;

import fc.jdbc.*;
import fc.io.*;
import fc.util.*;

/**
The base Manager class which is extended by all generated "Mgr" classes.

@author hursh jain
*/
public class DBOMgr
{
protected static Log log = Log.getDefault();

/**
Returns the logger that is used for all generated Manager classes.
*/
public static final Log getLog() {
	return log;
	}

/**
Sets the logger for all generated Manager classes.
*/
public static final void setLog(Log newlog) {
	synchronized (DBOMgr.class)
		{
		if (newlog == null) {
			log.warn("specified log was null, ignoring...");	
			return;
			}
		log = newlog;
		}
	}
	
}
