// Copyright (c) 2001 Hursh Jain (http://www.mollypages.org) 
// The Molly framework is freely distributable under the terms of an
// MIT-style license. For details, see the molly pages web site at:
// http://www.mollypages.org/. Use, modify, have fun !

package fc.jdbc.dbo;

import java.io.*;
import java.sql.*;
import java.util.*;
import java.util.logging.*;

import fc.jdbc.*;
import fc.io.*;
import fc.util.*;

/**
Mysql specific functions

@author hursh jain
**/
class DBmysql extends DBspecific
{
String 	currentTable;
Set 	currentTableCols;

boolean isAutoIncrement(Connection con, String table, String col, ResultSet rs) 
throws SQLException
	{
	/* does not work with the 3.1.3 or 5.0.3 connector/j drivers */
	/*
	String remarks 	= rs.getString ("REMARKS");
	if (remarks != null) {
		remarks = remarks.toLowerCase();
		if (remarks.indexOf("auto_increment") >= 0)
			return true;
		}
	return false;
	*/
	
	col = col.toLowerCase();
	
	if (table.equals(currentTable)) {
		return currentTableCols.contains(col);
		}
	
	currentTableCols = new HashSet();
	
	Statement s = con.createStatement(ResultSet.TYPE_FORWARD_ONLY, ResultSet.CONCUR_READ_ONLY);
	
	//this re-use of resultset is fine, we are ignoring the parameter in case of mysql
	rs = s.executeQuery("SELECT * FROM " + table + " WHERE 1 = 0");

	ResultSetMetaData md = rs.getMetaData();
	int colcount = md.getColumnCount();
	for (int n = 1; n <= colcount; n++) {
		if (md.isAutoIncrement(n)) {
			String auto_inc_col = md.getColumnName(n);
			currentTableCols.add(auto_inc_col.toLowerCase());
			}
		}
	
	return currentTableCols.contains(col);
	}

String getAutoIncrementQuery(ColumnData cd) throws SQLException
	{
	//the columnname etc is irrelevant for mysql
	String query = "select last_insert_id()";
	return query;
	}

} //~class		



