// Copyright (c) 2001 Hursh Jain (http://www.mollypages.org) 
// The Molly framework is freely distributable under the terms of an
// MIT-style license. For details, see the molly pages web site at:
// http://www.mollypages.org/. Use, modify, have fun !

package fc.jdbc.dbo;

import java.io.*;
import java.sql.*;
import java.util.*;
import java.util.logging.*;

import fc.jdbc.*;
import fc.io.*;
import fc.util.*;

/**
PostgresQL specific functions

@author hursh jain
**/
class DBpostgresql extends DBspecific
{
boolean isAutoIncrement(Connection con, String table, String col, ResultSet rs) 
throws SQLException 
	{
	String coldef 	= rs.getString("COLUMN_DEF");
	if (coldef != null) {
		coldef = coldef.toLowerCase();
		if (coldef.indexOf("nextval") >= 0)
			return true;
		}
	return false;
	}

String getAutoIncrementQuery(ColumnData cd) throws SQLException
	{
	//postgres uses: tablename_colname_seq
	String tablename = cd.getTable().getName();
	String colname = cd.getName();
	String query = "select currval('" + tablename + "_" + colname + "_seq')";
	return query;
	}

} //~class		
