// Copyright (c) 2001 Hursh Jain (http://www.mollypages.org) 
// The Molly framework is freely distributable under the terms of an
// MIT-style license. For details, see the molly pages web site at:
// http://www.mollypages.org/. Use, modify, have fun !

/**
These are <b>sample</b> tables, purely to show as an example of DBO generated code. This is so you can 
look at various methods in the {@link alltypesMgr} class to see the DBO operations that can be
carried out in a row represented by {@link alltypes}
<p>
This package is for documentation of DBO operations only. There is no run-time utility or use 
of this package apart from the documentation.
<p>
In postgres, the example <i>alltypes</i> table looks like so:
<pre>
     Column      |            Type             |                       Modifiers                       
-----------------+-----------------------------+-------------------------------------------------------
 id              | integer                     | not null default nextval('alltypes_id_seq'::regclass)
 smallint_val    | smallint                    | 
 int_val         | integer                     | not null
 bigint_val      | bigint                      | 
 float_val       | real                        | 
 double_val      | double precision            | 
 numeric_val     | numeric(5,2)                | 
 char_val        | character(10)               | 
 varchar_val     | character varying(10)       | 
 longvarchar_val | text                        | 
 date_val        | date                        | 
 time_val        | time without time zone      | 
 timestamp_val   | timestamp without time zone | 
 bit_val         | bit(1)                      | 
 array_val       | character varying(10)[]     | 
 boolean_val     | boolean                     | 
 varbinary_val   | bytea                       | 
Indexes:
    "alltypes_pkey" PRIMARY KEY, btree (id)
</pre>
<p>
For this example table, the DBO generates an <tt>alltypes</tt> bean (corresponding to the columns/attributes
in this table) as well as a <tt>alltypesMgr</tt> class that operates on these <tt>alltypes</tt> beans.
*/
package fc.jdbc.dbo.generated;

//rest of the file is empty