// Copyright (c) 2001 Hursh Jain (http://www.mollypages.org) 
// The Molly framework is freely distributable under the terms of an
// MIT-style license. For details, see the molly pages web site at:
// http://www.mollypages.org/. Use, modify, have fun !

package fc.net;

import java.net.*;
import java.io.*;
import fc.util.*;
import fc.io.*;

/**
A simple interactive network client. Provides a command 
line where the user can enter text. This is then sent
to the server and the servers response is displayed.
Typing <tt>exit</tt> will terminate the program.
**/
public class SimpleClient
{
/** 
the characters that we expect to come over our network 
**/
String encoding = "ISO-8859-1";
Socket con;
CmdLine cmdline;

public static void main(String[] args) throws Exception
	{
	new SimpleClient().run(args);
	}

public void run(String[] args) {
	Args myargs = new Args(args);
	myargs.setUsage(
		"Usage: java SimpleClient -host hostname -port port_number" +
		IOUtil.LINE_SEP +
		"If hostname is not specified, the localhost is used."
		);
	int port = Integer.parseInt(myargs.getRequired("port"));
	String host = myargs.get("host", "localhost");
	
	//--------- connect ---------
	try {
		con = new Socket(host, port);
		cmdline = new CmdLine(); 
		cmdline.setPrompt("> ");
		cmdline.start();
		}
	catch (Exception e) {
		e.printStackTrace();
		System.exit(1);
		}	
	System.out.println("Connected. " + con);	

	//-------- talk ---------------
    new Thread(new SimpleClientSendThread()).start();
	new Thread(new SimpleClientRecvThread()).start();
	}
	
class SimpleClientSendThread implements Runnable
{
public void run() {
try {
    OutputStream out = con.getOutputStream();
    PrintWriter pout = new PrintWriter(
    						new OutputStreamWriter(out, encoding));
	while (true) {
		//socket's isConnected() etc methods always say I am connected,
		//connection is open etc ever after the server closes the
		//connection. that sucks. this happens even on jdk1.4 
		//System.out.println("socket: bound="+con.isBound()+",connected="+con.isConnected()+",closed="+con.isClosed());
		// if (con.isClosed()) { break; }
		//we have to check for exceptions while writing to see if the
		//socket is still open
		String output = cmdline.getNextLine(); 
		if (output.equalsIgnoreCase("exit"))
			break;
		pout.print(output);
		pout.print("\n");
		if (pout.checkError()) {
			System.out.println("Could not send data. Server has closed connection");
			break;
			}	
		}
	System.out.println("Closing the client.");
    con.close();
	cmdline.stop();
	}
catch (Exception e) { 		
	e.printStackTrace();
	}
} //~run
}	//~SendThread

class SimpleClientRecvThread implements Runnable
{
public void run() {
try {
	InputStream in = con.getInputStream();
	BufferedReader bin = new BufferedReader(
						  new InputStreamReader(in, encoding));
	String tmp;
	while ( (tmp = bin.readLine()) != null) {
		cmdline.writeln("[server>] " + tmp);	
		cmdline.writeWithoutPrompt("");
		}
	}
catch (Exception e) { 
	e.printStackTrace();
	}
} //~run

} //~RecvThread


} //~SimpleClient
