// Copyright (c) 2001 Hursh Jain (http://www.mollypages.org) 
// The Molly framework is freely distributable under the terms of an
// MIT-style license. For details, see the molly pages web site at:
// http://www.mollypages.org/. Use, modify, have fun !

package fc.net;

import java.net.*;
import java.io.*;
import fc.util.*;
import fc.io.*;
import EDU.oswego.cs.dl.util.concurrent.*;

/**
A simple interactive server. Provides a command 
line where the user can enter text. This is then sent
to the client and the client's response is displayed.
Since this server is interactive, it accepts only 1 connection 
at one time.
Typing <tt>exit</tt> will terminate the program.
**/
public class SimpleServer
{
Semaphore allowedConnections = new Semaphore(1);
/** 
the characters that we expect to come over our network 
**/
String encoding = "ISO-8859-1";

public static void main(String[] args) throws Exception
	{
	new SimpleServer().run(args);
	}

public void run(String[] args) throws Exception {
	Args myargs = new Args(args);
	myargs.setUsage(
		"Usage: java SimpleServer -ip ip_address -port port_number" +
		IOUtil.LINE_SEP +
		"If hostname is not specified, the localhost is used."
		);
	int port = Integer.parseInt(myargs.getRequired("port"));
	String host = myargs.get("ip", "127.0.0.1");
	InetAddress address = InetAddress.getByName(host);
	
	//--------- connect ---------
	try {
	
	//Backlog specified as 1
	//However typically the OS backlog limit overrides anything we
	//specify - for example on NT the limit is 5 except with Windows
	//NT Server where the limit is 200
	//This is from the JDC but is not mentioned in the ServerSocket docs
		
		ServerSocket sock = new ServerSocket(port, 1, address);
	
		//receive buffer is not the queue length but the data buffer
		//for each open socket.
		//receive buffer = " + sock.getReceiveBufferSize()
		System.out.println("Server started. " + sock);
		while (true) {
			System.out.println("waiting for acquire, can accept connections="+ allowedConnections.permits());
			allowedConnections.acquire(); 
			Socket con = sock.accept();
			System.out.println("Accepted connection. " + con);
			Console console = new Console(); 
			cmdline.setPrompt("> ");
			cmdline.start();
		    new Thread(new SimpleServerSendThread(con, cmdline)).start();
			new Thread(new SimpleServerRecvThread(con, cmdline)).start();
			}
		}
	catch (Exception e) {
		e.printStackTrace();
		System.exit(1);
		}	
	}
	
class SimpleServerSendThread implements Runnable
{
Socket con;
CmdLine cmdline;
public SimpleServerSendThread(Socket con, CmdLine cmdline) {
	this.con = con;
	this.cmdline = cmdline;
	}
public void run() {
try {
    OutputStream out = con.getOutputStream();
    PrintWriter pout = new PrintWriter(new OutputStreamWriter(out, encoding));
	while (true) {
		//socket's isConnected() etc methods always say I am connected,
		//connection is open etc ever after the server closes the
		//connection. that sucks. this happens even on jdk1.4 
		//System.out.println("socket: bound="+con.isBound()+",connected="+con.isConnected()+",closed="+con.isClosed());
		// if (con.isClosed()) { break; }
		//we have to check for exceptions while writing to see if the
		//socket is still open
		String output = cmdline.getNextLine(); 
		if (output.equalsIgnoreCase("exit"))
			break;
		pout.print(output);
		pout.print("\n");
		if (pout.checkError()) {
			cmdline.writeln("Could not send data. Client has closed connection");
			break;
			}	
		}
	System.out.println("Closing the connection.");
    con.close();
	cmdline.stop();
	allowedConnections.release();
	}
catch (Exception e) { 		
	e.printStackTrace();
	}
} //~run
}	//~SendThread

class SimpleServerRecvThread implements Runnable
{
Socket con;
CmdLine cmdline;
public SimpleServerRecvThread(Socket con, CmdLine cmdline) {
	this.con = con;
	this.cmdline = cmdline;
	}
public void run() {
try {
	InputStream in = con.getInputStream();
	BufferedReader bin = new BufferedReader(new InputStreamReader(in, encoding));
	String tmp;
	while ( (tmp = bin.readLine()) != null) {
		cmdline.writeln("[client>] " + tmp);	
		cmdline.writeWithoutPrompt("");
		if (! cmdline.isRunning()) {
			break;
			}
		}
	}
catch (Exception e) { 
	e.printStackTrace();
	}
} //~run

} //~RecvThread


} //~SimpleServer
