// Copyright (c) 2001 Hursh Jain (http://www.mollypages.org) 
// The Molly framework is freely distributable under the terms of an
// MIT-style license. For details, see the molly pages web site at:
// http://www.mollypages.org/. Use, modify, have fun !

package fc.util;

import java.util.*;
import fc.io.*;

/**
Misc. utils
*/
public final class MiscUtil
{
public static final String java_keywords[] = {
	"abstract", "assert", "boolean", "break", "byte", "case", "catch",
	"char", "class", "const", "continue", "default", "do", "double",
	"else", "extends", "false", "final", "finally", "float", "for",
	"goto", "if", "implements", "import", "instanceof", "int",
	"interface", "long", "native", "new", "null", "package", "private",
	"protected", "public", "return", "short", "static", "strictfp",
	"super", "switch", "synchronized", "this", "throw", "throws",
	"transient", "true", "try", "void", "volatile", "while" 
	};

/** 
Returns true if the specified word is a Java Language Keyword. Keywords (and hence this comparison) are case sensitive, upper case versions of these are ok in Java. 
*/
public static boolean isJavaKeyword(String word) {
	return (Arrays.binarySearch(java_keywords, word) >= 0);
	}

public static void main (String args[])
	{
	Args myargs = new Args(args);
	System.out.println(isJavaKeyword(myargs.getRequired("word")));
	}
	
}

