// Copyright (c) 2001 Hursh Jain (http://www.mollypages.org) 
// The Molly framework is freely distributable under the terms of an
// MIT-style license. For details, see the molly pages web site at:
// http://www.mollypages.org/. Use, modify, have fun !

package fc.util;

import java.util.*;

/** 
A range of values such as numbers, dates etc. 

@author hursh jain
**/
public abstract class Range 
{
protected boolean negated = false;
	
/** Checks if this range is negated. **/
public boolean isNegated() {
	return negated;
	}	

/** 
Sets this range to be negated or not. By default
ranges are <b>not</b> negated.

@param	val		<tt>true</tt> to set negated
**/
public void setNegated(boolean val) {
	negated = val;
	}
	
}          //~class Range