// Copyright (c) 2001 Hursh Jain (http://www.mollypages.org) 
// The Molly framework is freely distributable under the terms of an
// MIT-style license. For details, see the molly pages web site at:
// http://www.mollypages.org/. Use, modify, have fun !

package fc.web;

import java.util.*;
import java.io.*;

public class HTMLConvertor
{
/**	Returns a banner type html table. Specify null for any parameter
 *	that should be ignored.
 *	@param bgcolor	string specifying the bgcolor for the table. 
 * 					(include the "#" sign if hex value)
 *	@param contents	the contents of the banner
 */
public static String getBanner(String bgcolor, String[] contents) 
	{
	String result = "<table bgcolor="+ bgcolor + " cellpadding=10 width='100%'>\n";
    result += "<tr><td> <font face='arial, helvetica' color='white'><center>\n";
    String temp = null;
	for (int i = 1; i < contents.length; i++) 
		{
		temp = contents[i];
		result +=  "<font size=+2>" + temp.substring(0,1) + "</font>";
		result +=  "<font size='+1'>" + temp.substring(1,temp.length()) + 
					"</font>\n";
		}
   	result += "\n</center></font></td></tr></table>\n";
	return result;
	}		//~getBanner


/** Takes a 2D data struct (vector of Object[]) and 
 * returns it as a HTML table. Table headers are taken
 * from the header parameter, if the header parameter is null,
 * they are taken from the first row of the resultvector parameter.
 */
public static String toTable(List resultvector, String[] header)
	{
	int len = resultvector.size();
	Object[][] data = new String[len][];
	for (int n = 0; n < len; n++)
		data[n] = (Object[]) resultvector.get(n);
	return toTable(data, header);
	}

/** Calls toTable(data, null) */
public static String toTable(String[][] data)
	{
	return toTable(data, null);	
	}

/** Takes a 2D data struct (array of Object[]) and returns it
*   as an HTML table. If a header is specified, the table headers 
*	are taken from that, otherwise the headers are taken from the first
* 	row of the data array
*/
public static String toTable(Object[][] data, String[] header)
	{
	Object[] record;  
	StringBuffer resultbuf = new StringBuffer(512);
	resultbuf.append("<table border=0 cellspacing=2 cellpadding=3>\n");
	resultbuf.append("\t<tr bgcolor='#ccccdd'>\n");
	
	if (header == null)
	{
	//a particular row from the result set, is a String[] 
	//containing column values
	record = data[0];  
	int recordlen = record.length;
	//write out column names using the column names we get in the resultset
	for (int m = 0; m < recordlen; m++)
		{
		resultbuf.append("\t\t<TH valign='top'>");
		resultbuf.append(record[m]);
		resultbuf.append("</th>\n");
		}
	resultbuf.append("\t</tr>\n");
	}
	else		//(header != null)
	{
	//write out column names using the header parameter
	for (int m = 0; m < header.length; m++)
		{
		resultbuf.append("\t\t<TH valign='top'>");
		resultbuf.append(header[m]);
		resultbuf.append("</th>\n");
		}
	resultbuf.append("\t</tr>\n");
	}
		
	//write out column names using our own column names (make sure that
	//these are in sync with the query
	
	//write search results
	String cellvalue = null;
	for (int n = 1; n < data.length; n++)	
			//start from n=1 because n=0 contains column header info
		{
		resultbuf.append("\t<tr bgcolor='#ccccdd'>\n");
		record = data[n];
		int recordlen = record.length;
		for (int m = 0; m < recordlen; m++)  
			{			
			resultbuf.append("\t\t<TD valign='top'");	
			if (record[m] != null) 
				{
				if (cellvalue.equalsIgnoreCase("null"))
				 	cellvalue = "-";
				else
					cellvalue = (String) record[m];		
				}
			else { 
				cellvalue = "-";
				}
			resultbuf.append("<font size='-2'> " + cellvalue + " </font> ");
			resultbuf.append(" </td>\n");
			}							//~ inner for
		resultbuf.append("\t</tr>\n");
		}									//for loop
	resultbuf.append("</table>\n");	
	return resultbuf.toString();	
	}  //~toTable()

/** Takes a 2D data struct (vector of string[]) and 
 * 	returns the element at row, col 
 *  @Exception if row, col are out of bounds or data is null
 */
public static String gridElementAt(int row, int col, Vector data)
					throws Exception
	{
	if (data == null)
		throw new Exception("gridElementAt(): Null data");
	int datalen = data.size();
	String[] arow = (String[]) data.elementAt(row);
	return arow[col];
	}

} //~class HTMLConvertor





