// Copyright (c) 2001 Hursh Jain (http://www.mollypages.org) 
// The Molly framework is freely distributable under the terms of an
// MIT-style license. For details, see the molly pages web site at:
// http://www.mollypages.org/. Use, modify, have fun !

package fc.web.forms;

import javax.servlet.*;
import javax.servlet.http.*;
import java.io.*;
import java.util.*;
import java.util.regex.*;
import java.util.logging.*;

import fc.jdbc.*;
import fc.io.*;
import fc.util.*;

/** 
Represents a HTML form's checkbox element.

@author hursh jain
**/
public final class Checkbox extends Choice
{
/** 
Creates a new checkbox object.

@param 	name		the field name
@param 	value		the value of this choice item
@param	selected	<tt>true</tt> is this choice is 
					originally selected
**/
public Checkbox(String name, String value, boolean selected)
	{
	super(name, value, selected);
	}

/** 
Constructs a new unselected checkbox with the specified value 
and HTML text. 

@param	name		the name of this choice
@param 	value		the value of this choice item
**/
public Checkbox(String name, String value) {
	this(name, value, false);
	}

/** 
Constructs a new checkbox which is selected/unselected as specified.

@param	name		the name of this choice
@param	selected	<tt>true</tt> to select this checkbox.
**/
public Checkbox(String name, boolean selected) {
	this(name, null, selected);
	}


/** 
Constructs a new unselected checkbox with no separate 
value attribute

@param	name		the name of this choice
**/
public Checkbox(String name) {
	this(name, null, false);
	}

public Field.Type getType() {
	return Field.Type.CHECKBOX;
	}

}  