// Copyright (c) 2001 Hursh Jain (http://www.mollypages.org) 
// The Molly framework is freely distributable under the terms of an
// MIT-style license. For details, see the molly pages web site at:
// http://www.mollypages.org/. Use, modify, have fun !

package fc.web.forms;

import javax.servlet.*;
import javax.servlet.http.*;
import java.io.*;
import java.util.*;

import fc.jdbc.*;
import fc.io.*;
import fc.util.*;

/** 
Keeps track of a set of related/grouped fields in a form.
<p>
A fieldref is is useful when a set of fields are created
programmatically from a database table and need to be
retrieved from the form (but we don't know the names of
those fields since they were created dynamically -- however,
those fields can be added both to the form and to a
fieldref and obtained via then the name of the fieldref
(whose name we <b>do</b> know.)
<p>
<b>Note</b>: Any fields contained in this object must also
be added directly to the form.

@author hursh jain
**/
public final class FieldRef
{
String 	name;
Object	obj;

/** 
Creates a new field with the specified name. All fieldref's
in a particular form must have a unique name.
**/
public FieldRef(String name)
	{
	this.name = name;
	}

/** 
Creates a new field with the specified name and the
specified object (which may be any data structure like a
list, map or whatever containing references to fields in
the form).
**/
public FieldRef(String name, Object obj)
	{
	this.name = name;
	this.obj = obj;
	}


/**
Adds an object to this fieldref. The object will typically
be some datastructure that contains references to fields
in the form.
*/
public void add(Object obj)
	{
	this.obj = obj;
	}

/**
Returns the data object contained in this fieldref as a List.
*/
public List getList() {
	return (List) obj;
	}
	

/**
Returns the data object contained in this fieldref as a Map.
*/
public Map getMap() {
	return (Map) obj;
	}

/**
Returns the data object contained in this fieldref.
*/
public Object getObject()
	{
	return obj;
	}

String getName() {
	return name;
	}
	
public String toString() {
	StringBuffer buf = new StringBuffer();
	buf.append("FieldRef: ").append(name);
	buf.append("; Contains: \n");	
	buf.append(obj);
	return buf.toString();
	}
	
}          //~class Text