// Copyright (c) 2001 Hursh Jain (http://www.mollypages.org) 
// The Molly framework is freely distributable under the terms of an
// MIT-style license. For details, see the molly pages web site at:
// http://www.mollypages.org/. Use, modify, have fun !

package fc.web.forms;

import java.lang.reflect.*;
import java.io.*;
import java.text.*;
import java.util.*;

import fc.jdbc.*;
import fc.io.*;
import fc.util.*;
import fc.web.forms.*;
//for testing
import fc.jdbc.dbo.generated.*;

/**
Misc. form related utilities.

@author hursh jain
*/
public class FormUtil
{
private static final Class[]  classarr = new Class[] { };
private static final Object[] objarr = new Object[] { };

/**
<b>Note: This method is almost never needed. Use the {@link Select#useQuery(Connection, String)}
method instead.
</b>
<p>
Fills in the specified select with values from the supplied list. This is
intended to show a select widget corresponding to a lookup table in the
database. The list will typically be returned by <tt>getAll/getWhere</tt>
methods of some generated {@link fc.jdbc.dbo.DBOMgr} class.
<p>
For example, given a lookup table object <tt>Foo</tt> and a corresponding
manager object <tt>FooMgr</tt> and an empty previously-instantiated
select:
<tt>
<blockquote> 
<pre>
Select select = new Select("myselect")
fillSelect(select, FooMgr.getAll(), 
	"--choose--", 
     Foo.class, <font color=red>"getID"</font>, 
     <font color=red>"getValue"</font>);
</pre>
</blockquote>
</tt>
and where table Foo has the following data
<blockquote>
<tt><pre>
 Table Foo
 <font color=red>
	ID			Value</font>
 -----------------------------------
 	1			"lookup_one"
	2			"lookup_two"
	3			"lookup_three"
</pre></tt>
</blockquote>
will add the following values to the select:
<blockquote>
<tt>
<pre>
&lt;option&gt;--choose--&lt;/option&gt;
&lt;option value=1&gt;lookup_one&lt;/option&gt;
&lt;option value=2&gt;lookup_two&lt;/option&gt;
&lt;option value=3&gt;lookup_three&lt;/option&gt;
</pre>
</tt>
</blockquote>
<p>

@param	select
	a select object to be filled in
@param	list			  
	list of objects of type beanClass. Typically
	this would be obtained via invoking the
	<tt>beanClassMgr.getAll()</tt> method
@param	message
	an optional message to show as the first value of
	the select option (typically <tt>---select--</tt>
	or <tt>--choose an option--</tt> etc.). Specify
	<tt>null</tt> to skip creating this optional message.
@param	beanClass		  
	the {@link DBO} class corresponding to some lookuptable in the
	database
@param	valueMethodName   
	the name of the method in the {@link DBO} class which will be used to
	create the value for a radio button [ without "()"]
@param	htmlTextMethodName  
	the name of the method in the {@link DBO} class which will be used to
	create the html text displayed to the user for a radio button [name
	should be without "()"]

@throws IllegalArgumentException 
	if an error occurred in getting the specified methods
	from the specified class and invoking them on the
	specified list
*/
public static void fillSelect(
	  Select select, List list, String message, 
	  Class beanClass, 
	  String valueMethodName, String htmlTextMethodName)	
	{
	if (message != null)
		select.add(new Select.Option(message));
	
	try {
		Method value_method = beanClass.getDeclaredMethod(
							   valueMethodName, classarr);
		Method html_method =  beanClass.getDeclaredMethod(
							   htmlTextMethodName, classarr);
	
		for (int n = 0; n < list.size(); n++)
			{
			Object obj = list.get(n);
			String value = String.valueOf(value_method.invoke(obj, objarr));
			String html  = String.valueOf(html_method.invoke(obj, objarr));
			select.add(new Select.Option(html, value)); 
			}
		}
	catch (Exception e) {
		throw new IllegalArgumentException(IOUtil.throwableToString(e));
		}		
	}

/**
<b>Note: This method is almost never needed. Use the {@link Select#useQuery(Connection, String)}
method instead.
</b>
<p>
Fills in the specified select with values from the supplied map. This is
intended to show a select widget corresponding to a lookup table in the
database. The list will typically be returned by <tt>getAll/getWhere</tt>
methods of some generated {@link fc.jdbc.dbo.DBOMgr} class.
<p>
For example, given a lookup table object <tt>Foo</tt> and a corresponding
manager object <tt>FooMgr</tt> and an empty previously-instantiated
select:
<tt>
<blockquote>
<pre>
Select select = new Select("myselect")
fillSelect(select, FooMgr.getAll(), 
	"--choose--", 
     Foo.class, <font color=red>"getID"</font>, 
     <font color=red>"getValue"</font>);
</pre>
</blockquote>
</tt>
and where table Foo has the following data
<blockquote>
<tt><pre>
 Table Foo
 <font color=red>
	ID			Value</font>
 -----------------------------------
 	1			"lookup_one"
	2			"lookup_two"
	3			"lookup_three"
</pre></tt>
</blockquote>
will add the following values to the select:
<blockquote>
<tt>
<pre>
&lt;option&gt;--choose--&lt;/option&gt;
&lt;option value=1&gt;lookup_one&lt;/option&gt;
&lt;option value=2&gt;lookup_two&lt;/option&gt;
&lt;option value=3&gt;lookup_three&lt;/option&gt;
</pre>
</tt>
</blockquote>
<p>

@param	select
	a select object to be filled in
@param	values
	A map containing the values for the select. For each key, value pair,
	the following will be generated for the select:
	<pre><option value="key-part">value-part</option>
@param	message
	an optional message to show as the first value of the select option
	(typically <tt>---select--</tt> or <tt>--choose an option--</tt> etc.).
	Specify <tt>null</tt> to skip creating this optional message.

*/
public static void fillSelect(Select select, Map values, String message)
	{
	if (message != null)
		select.add(new Select.Option(message));
	
	try {
		Iterator it = values.entrySet().iterator(); 
		while (it.hasNext()) {
			Map.Entry e = (Map.Entry)it.next();
			select.add(new Select.Option((String)e.getKey(), (String)e.getValue())); 
			}
		}
	catch (Exception e) {
		throw new IllegalArgumentException(IOUtil.throwableToString(e));
		}		
	}


/** 
Fills in the specified radiogroup with values from the supplied list. This
is intended to show radio groups corresponding to a lookup table in the
database. The list will typically be returned by <tt>getAll/getWhere</tt>
methods of some generated {@link fc.jdbc.dbo.DBOMgr} class. <p> For
example, given a lookup table object <tt>Foo</tt> and a corresponding
manager object <tt>FooMgr</tt> and a empty previously-instantiated radio
group:
<tt>
<blockquote>
<pre>
RadioGroup rg = new RadioGroup("myradio")
fillRadioGroup(select, FooMgr.getAll(), 
     Foo.class, <font color=red>"getID"</font>, 
     <font color=red>"getValue"</font>);
</pre>
</blockquote>
</tt>
and where table Foo has the following data:
<blockquote>
<tt><pre>
 Table Foo
 <font color=red>
	ID			Value</font>
 -----------------------------------
 	1			"lookup_one"
	2			"lookup_two"
	3			"lookup_three"
</pre></tt>
</blockquote>
will add those values to the radio group.

@param	rg
	a radio group object to be filled in
@param	list			  
	list of objects of type beanClass. Typically
	this would be obtained via invoking the
	<tt>beanClassMgr.getAll()</tt> method
@param	beanClass		  
	the {@link DBO} class corresponding to some lookuptable in the
	database
@param	valueMethodName   
	the name of the method in the {@link DBO} class which will be used to
	create the value for a radio button [ without "()"]
@param	htmlTextMethodName  
	the name of the method in the {@link DBO} class which will be used to
	create the html text displayed to the user for a radio button [name
	should be without "()"]

@throws IllegalArgumentException 
	if an error occurred in getting the specified methods
	from the specified class and invoking them on the
	specified list
*/
public static void fillRadioGroup(
	RadioGroup rg, List list, Class beanClass,
	String valueMethodName, String htmlTextMethodName)	
	{
	try {
		Method value_method = beanClass.getDeclaredMethod(
							valueMethodName, classarr);
		Method html_method = beanClass.getDeclaredMethod(
							htmlTextMethodName, classarr);
		for (int n = 0; n < list.size(); n++)
			{
			Object obj = list.get(n);
			String value = String.valueOf(value_method.invoke(obj, objarr));
			String html  = String.valueOf(html_method.invoke(obj, objarr));
			ChoiceGroup.Choice c = new ChoiceGroup.Choice(html, value); //auto adds it to rg
			rg.add(c);
			}
		}
	catch (Exception e) {
		throw new IllegalArgumentException(IOUtil.throwableToString(e));
		}		
	}

/** 
Fills in the specified checkboxgroup with values from the supplied list.
This is intended to show checkbox groups corresponding to a lookup table
in the database. The list will typically be returned by <tt>getAll or
getWhere</tt> methods of some generated {@link fc.jdbc.dbo.DBOMgr} class.
<p>
For example, given a lookup table object <tt>Foo</tt> and a corresponding
manager object <tt>FooMgr</tt> and a empty previously-instantiated
checkbox group:
<tt>
<blockquote>
<pre>
CheckboxGroup rg = new CheckboxGroup("mycbgroup")
fillCheckboxGroup(select, FooMgr.getAll(), 
     Foo.class, <font color=red>"getID"</font>, 
     <font color=red>"getValue"</font>);
</pre>
</blockquote>
</tt>
and where table Foo has the following data:
<blockquote>
<tt><pre>
 Table Foo
 <font color=red>
	ID			Value</font>
 -----------------------------------
 	1			"lookup_one"
	2			"lookup_two"
	3			"lookup_three"
</pre></tt>
</blockquote>
will add those values to the checkbox group.

@param	cbg
	a checkbox group object to be filled in
@param	list			  
	list of objects of type beanClass. Typically
	this would be obtained via invoking the
	<tt>beanClassMgr.getAll()</tt> method
@param	beanClass		  
	the {@link DBO} class corresponding to some lookuptable in the
	database
@param	valueMethodName   
	the name of the method in the {@link DBO} class which will be used to
	create the value for a radio button [ without "()"]
@param	htmlTextMethodName  
	the name of the method in the {@link DBO} class which will be used to
	create the html text displayed to the user for a radio button [name
	should be without "()"]

@throws IllegalArgumentException 
	if an error occurred in getting the specified methods
	from the specified class and invoking them on the
	specified list
*/
public static void fillCheckboxGroup(
	CheckboxGroup cbg, List list, Class beanClass,
	String valueMethodName, String htmlTextMethodName)	
	{
	try {
		Method value_method = beanClass.getDeclaredMethod(
							valueMethodName, classarr);
		Method html_method = beanClass.getDeclaredMethod(
							htmlTextMethodName, classarr);
		for (int n = 0; n < list.size(); n++)
			{
			Object obj = list.get(n);
			String value = String.valueOf(value_method.invoke(obj, objarr));
			String html  = String.valueOf(html_method.invoke(obj, objarr));
			ChoiceGroup.Choice c = new ChoiceGroup.Choice(html, value); //auto adds it to rg
			cbg.add(c);
		}
		}
	catch (Exception e) {
		throw new IllegalArgumentException(IOUtil.throwableToString(e));
		}		
	}


/**
Fills the specified select from years, starting with the specified year
till the current year. No year option is pre-selected.
*/
public static Select fillSelectWithYears(Select s, int startYear)
	{	
	int now = Calendar.getInstance().get(Calendar.YEAR);
	for (int n = startYear; n <= now; n++)
		{
		Select.Option so = new Select.Option(n + "");
		s.add(so);
		}
	return s;
	}

/**
Fills the specified select from years, starting with the specified year.
The current year (on the server) is pre-selected.
*/
public static Select fillSelectWithYearsToday(Select s, int startYear)
	{
	return fillSelectWithYears(s, startYear, Calendar.getInstance());
	}

/**
Fills the specified select from years, starting with the specified year,
upto the current year. The date from the specified calendar is
pre-selected.
*/
public static Select fillSelectWithYears(
	Select s, int startYear, Calendar yearToSelect)
	{
	int now = Calendar.getInstance().get(Calendar.YEAR);
	int select = yearToSelect.get(Calendar.YEAR);
	
	for (int n = startYear; n <= now; n++)
		{
		Select.Option so = (n == select) ? new Select.Option(n + "", true) :
										new Select.Option(n + "");
		s.add(so);
		}
	return s;
	}

/**
Fills the specified select from years, from the specified start and end
years (both inclusive). The date from the specified calendar is
pre-selected.
*/
public static Select fillSelectWithYears(
 Select s, int startYear, int endYear, Calendar cal)
	{
	int select = cal.get(Calendar.YEAR);
	
	for (int n = startYear; n <= endYear; n++)
		{
		Select.Option so = (n == select) ? new Select.Option(n + "", true) :
										new Select.Option(n + "");
		s.add(so);
		}
	return s;
	}

private static String[] months = new String[]
	{
	/*0-th is empty -->*/ "",
	"Jan", "Feb", "March", "Apr", "May", "June", "July",
	"Aug", "Sept", "Oct", "Nov", "Dec"	
	};

//TODO: i18n
/**
Fills the specified select from years, starting with the specified year.
<tt>monthsAsText</tt> specifies whether months are displayed as names
or numbers. (true for names). No month is preselected.
*/
public static Select fillSelectWithMonths(Select s, boolean monthsAsText)
	{
	String month = null;
	for (int n = 1; n <= 12; n++)
		{
		if (monthsAsText)
			month = months[n];
		else
			month = n + "";
			
		Select.Option so = new Select.Option(n+"", month);
		s.add(so);
		}
	return s;
	}

/**
Fills the specified select from years, starting with the specified year.
<tt>monthsAsText</tt> specifies whether months are displayed as names or
numbers. (true for names). The current month (on the server) is preselected.
*/
public static Select fillSelectWithMonthsToday(Select s, boolean monthsAsText)
	{
	return fillSelectWithMonths(s, monthsAsText, Calendar.getInstance());
	}

/**
Fills the specified select from years, starting with the specified year.
<tt>monthsAsText</tt> specifies whether months are displayed as names or
numbers. (true for names). The current month from the specified calendar is
is preselected.
*/
public static Select fillSelectWithMonths(
		Select s, boolean monthsAsText, Calendar cal)
	{
	String month = null;
	int current_month = cal.get(Calendar.MONTH)/*0-based*/ + 1;

	for (int n = 1; n <= 12; n++)
		{
		if (monthsAsText)
			month = months[n];
		else
			month = n + "";
			
		Select.Option so = (n == current_month) ? 
								new Select.Option(n+"", month, true) 
								: new Select.Option(n+"", month);
		s.add(so);
		}
	return s;
	}


/**
Fills the specified select from years, starting with the specified year.
No day is pre-selected.
*/
public static Select fillSelectWithDays(Select s)
	{
	for (int n = 1; n <= 31; n++)
		{
		Select.Option so = new Select.Option(n + "");
		s.add(so);
		}
	return s;
	}

/**
Fills the specified select from years, starting with the specified year.
Today (on the server side) is preselected.
*/
public static Select fillSelectWithDaysToday(Select s)
	{
	return fillSelectWithDays(s, Calendar.getInstance());
	}

/**
Fills the specified select from years, starting with the specified year.
The day in the specified date is preselected.
*/
public static Select fillSelectWithDays(Select s, Calendar cal)
	{
	int today = cal.get(Calendar.DATE);	
	for (int n = 1; n <= 31; n++)
		{
		Select.Option so = (n == today) ? new Select.Option(n + "", true)
										: new Select.Option(n + "");
		s.add(so);	
		}
	return s;
	}

/**
Converts a year, month and day into a java.sql.Date
*/
public static java.sql.Date toDate(String year, String month, String day)
	{
	
	java.sql.Date date = new java.sql.Date(
							new java.util.Date(
								Integer.parseInt(year)-1900, 
								Integer.parseInt(month)-1, 
								Integer.parseInt(day)).getTime());
	return date;
	}

/**
Converts a time string into a java.sql.Time. Time is of the format: HH:MM
(for example: <tt>1:23</tt> or <tt>01:23</tt>). Returns null if the
string could not be parsed. (Hours upto 12 are allowed but not 13 or
more). This method is suitable for a text box that takes 1-12 hours 
and a seperate am/pm select option next to it.
*/
public static java.sql.Time toTime(final String time)
	{	
	java.util.Date date = null;
	final DateFormat df = new SimpleDateFormat("h:mm");
	try {
		date = df.parse(time);
		}
	catch (Exception e) {
		return null;
		}
	
	return new java.sql.Time(date.getTime());
	}


public static void main(String args[])  throws Exception
	{
	PrintWriter pw = new PrintWriter(System.out);
	Select select = new Select("foo");

	Args myargs = new Args(args);
	myargs.setUsage("java fc.web.form.FormUtil -conf conf-file");
	
	String propfile = myargs.getRequired("conf");
	
	ConnectionMgr mgr = new SimpleConnectionMgr(  
								new FilePropertyMgr(
									new File(propfile)));
	java.sql.Connection con = mgr.getConnection();

	List list = alltypesMgr.getAll(con);

	long start = System.currentTimeMillis();
	fillSelect(select, list, "--choose--", alltypes.class, 
			"get_id", "get_char_val"); 
	System.out.println("time for first fillSelect() calls = " + (System.currentTimeMillis() - start) + " ms");
	select.render(pw);
	fillSelect(select, list, "--choose--", alltypes.class, 
			"get_id", "get_date_val"); 
	select.render(pw);
	fillSelect(select, list, "--choose--", alltypes.class, 
			"get_id", "get_int_val"); 
	select.render(pw);
	fillSelect(select, list, "--choose--", alltypes.class, 
			"get_id", "get_boolean_val"); 
	select.render(pw);


	RadioGroup rg = new RadioGroup("rg");
	start = System.currentTimeMillis();
	fillRadioGroup(rg, list, alltypes.class, 
			"get_id", "get_char_val"); 
	System.out.println("time for first fillRadioGroup() calls = " + (System.currentTimeMillis() - start) + " ms");
	rg.render(pw);
	fillRadioGroup(rg, list, alltypes.class, 
			"get_id", "get_date_val"); 
	rg.render(pw);
	fillRadioGroup(rg, list, alltypes.class, 
			"get_id", "get_int_val"); 
	rg.render(pw);
	fillRadioGroup(rg, list, alltypes.class, 
			"get_id", "get_boolean_val"); 
	rg.render(pw);

	Date d = new Date();
	System.out.println(d.getYear() + " " + d.getMonth() + " " + d.getDay());

	select = new Select("years");
	fillSelectWithYears(select, 1995);
	select.render(pw);

	fillSelectWithYears(select, 1995);
	select.render(pw);

	select = new Select("months");
	fillSelectWithMonths(select, true);
	select.render(pw);

	select = new Select("days");
	fillSelectWithDays(select);
	select.render(pw);

	pw.close();
//	con.close();
	}

} //~class