// Copyright (c) 2001 Hursh Jain (http://www.mollypages.org) 
// The Molly framework is freely distributable under the terms of an
// MIT-style license. For details, see the molly pages web site at:
// http://www.mollypages.org/. Use, modify, have fun !

package fc.web.forms;

import javax.servlet.*;
import javax.servlet.http.*;
import java.io.*;
import java.util.*;
import java.util.regex.*;
import java.util.logging.*;

import fc.jdbc.*;
import fc.io.*;
import fc.util.*;

/** 
Represents a grouped set of radio buttons

@author hursh jain
**/
public class RadioGroup extends ChoiceGroup
{
/** {@inheritDoc} **/
public RadioGroup(String name)
	{
	super(name);
	}
	
public Field.Type getType() {
	//no separate radiogroup since no such thing in HTML
	//radiogroups = radio's with same name
	return Field.Type.RADIO;
	}

/** 
Convenience method that returns the selected option as a
String. 
<p>
If there is no selection, returns <tt>null</tt>
**/
public String getStringValue(FormData fd) 
	{
	if ( ! isFilled(fd) ) 
		return null;
		
	ChoiceGroup.Data data = (ChoiceGroup.Data) fd.getData(name);
	Iterator it = data.selectedMap.values().iterator();
	return ( ((Choice)it.next()).getValue() );
	}

/**
Convenience method that returns the value of this 
field as a integer.

@throws NumberFormatException	if the value could not be
								returned as in integer.	
*/
public int getIntValue(FormData fd) 
	{
	return Integer.parseInt(getStringValue(fd));
	}

/**
Convenience method that returns the value of this 
field as a boolean. 
*/
public boolean getBooleanValue(FormData fd) {
	return Boolean.valueOf(getStringValue(fd)).booleanValue();
	}

}          