// Copyright (c) 2001 Hursh Jain (http://www.mollypages.org) 
// The Molly framework is freely distributable under the terms of an
// MIT-style license. For details, see the molly pages web site at:
// http://www.mollypages.org/. Use, modify, have fun !

package fc.web.forms;

import javax.servlet.*;
import javax.servlet.http.*;
import java.io.*;
import java.util.*;
import java.sql.*;

import fc.jdbc.*;
import fc.io.*;
import fc.util.*;

/** 
This class handles form submit data that may have been hacked/modified
by the client. By default, this class logs a warning. Subclasses should
override the {@link #handle} method as needed.

@author hursh jain
**/
public class SubmitHackedHandler
{
protected Log  log;

public SubmitHackedHandler(Form form)
	{
	this.log = form.log;
	}
	
/**
This method should handle submit data that is hacked (different than
the options/values allowed by the html form). Possible actions are
to log an error, email the developers, identify compromised machines etc.
<p>
If this method throws a {@link SubmitHackedException}, then further
form processing will stop and the invoking page/servlet can handle the
exception appropriately.
<p>
The default implementation simply logs the error and then returns.
*/
public void handle(HttpServletRequest req, String msg) throws SubmitHackedException
	{
	log.warn("HACKLERT: IP=", req.getRemoteAddr(), ": ", msg);
	}
	
}          //SubmitHackedHandler