// Copyright (c) 2001 Hursh Jain (http://www.mollypages.org) 
// The Molly framework is freely distributable under the terms of an
// MIT-style license. For details, see the molly pages web site at:
// http://www.mollypages.org/. Use, modify, have fun !

package fc.web.forms;

import javax.servlet.*;
import javax.servlet.http.*;
import java.io.*;
import java.util.*;
import java.util.regex.*;

import fc.jdbc.*;
import fc.io.*;
import fc.util.*;

/**
Validates a email address

@author hursh jain
**/
public final class VEmail extends FieldValidator
{
boolean 		allowEmpty;

/** 
Constructs a new email validator that does not allow empty
email address as valid
**/
public VEmail(AbstractText field, String errorMessage)
	{
	this(field, errorMessage, false);
	}

/**  
Constructs a new email validator that allows an empty email
address as valid if the <tt>allowEmpty</tt> argument is
<tt>true</tt>. This is useful for optional email fields.
**/
public VEmail(AbstractText field, String errorMessage, boolean allowEmpty)
	{
	super(field, errorMessage);
	this.allowEmpty = allowEmpty;
	}

//all top level domains are at least 2 chars
final static Pattern EmailPattern = Pattern.compile(".+@.+\\..+");
	
/** 
Works with any field that returns a String via it's {@link Field#getValue} method. 

@throws ClassCastException  If the field's {@link Field#getValue} method
							does not return a String
**/
public boolean validate(FormData fd, HttpServletRequest req) 
	{
	String val = ((AbstractText)field).getValue(fd);
		
	//val == null different from an empty string
	if (val == null)
		return false;

	if (allowEmpty && val.equals(""))
		return true;

	Matcher matcher = EmailPattern.matcher(val);	
	boolean valid = matcher.matches();
	return valid;
	}	

}          //~class VEmail

