// Copyright (c) 2001 Hursh Jain (http://www.mollypages.org) 
// The Molly framework is freely distributable under the terms of an
// MIT-style license. For details, see the molly pages web site at:
// http://www.mollypages.org/. Use, modify, have fun !

package fc.web.forms;

import javax.servlet.*;
import javax.servlet.http.*;
import java.io.*;
import java.util.*;
import java.util.regex.*;

import fc.jdbc.*;
import fc.io.*;
import fc.util.*;

/**
Validates that the field is filled out by the user.
**/
public final class VFilled extends FieldValidator
{
boolean 	isFilled = false;  

/** 
Creates a new validator that fails validation if the fields
is not filled out by the user.
**/
public VFilled(Field field, String errorMessage)
	{
	super(field, errorMessage);
	}

/** 
Validates a field's value to be isFilled.
**/
public boolean validate(FormData fd, HttpServletRequest req) 
	{
	boolean val = field.isFilled(fd);
	return val;
	}	

}      
