// Copyright (c) 2001 Hursh Jain (http://www.mollypages.org) 
// The Molly framework is freely distributable under the terms of an
// MIT-style license. For details, see the molly pages web site at:
// http://www.mollypages.org/. Use, modify, have fun !

package fc.web.forms;

import javax.servlet.*;
import javax.servlet.http.*;
import java.io.*;
import java.util.*;
import java.util.regex.*;

import fc.jdbc.*;
import fc.io.*;
import fc.util.*;

/**
Validates that a certain radio or checkbox button selected
(or not selected) implies that other fields in the form are 
also filled out. For example:
<p>
A radio button called "yes" is chosen by the user and
this requires that a "yes_detail" field be filled out.

@author hursh jain
**/
public class VFilledOnChoice extends VConditional
{
ChoiceGroup	cg;
List		postFields;
String		choiceValue;
boolean		onSelect = true;
boolean		anyFilledOK = false;
static final boolean dbg = false;

/** 
@param	f			 the form
@param	name		 name for this validator
@param	errorMessage validation error message
@param	choice		 a pre condition choice group
@param	val			 the specific value of the pre condition choice group
					 which will trigger the check to see that
					 post condition fields are filled out
@param	postFields 	 a non-empty list containing fields for
					 the post condition
*/
public VFilledOnChoice(Form f, String name, String errorMessage, 
 ChoiceGroup cg, String choiceValue, List postFields)
	{
	super(f, name, errorMessage);
	Argcheck.istrue(postFields.size() > 0, "specified post field list was empty");
	Argcheck.istrue(cg != null, "specified choicegroup field was null");
	Argcheck.istrue(choiceValue != null && choiceValue.length() > 0, "choiceValue was null or empty");
	
	this.cg = cg;
	this.choiceValue = choiceValue;
	
	//we must make a copy of the fields because the caller
	//can change the list behind our back (by re-using the
	//list variable during form creation)
	this.postFields =  new ArrayList(postFields);
	}

public VFilledOnChoice(Form f, String name, String errorMessage, 
 ChoiceGroup cg, String choiceValue, Field[] postFields)
	{
	this(f, name, errorMessage, cg, choiceValue, 
		Arrays.asList(postFields));
	}

/**
By default, this validator checks to see that <i>all</i>
post-condition fields are filled. However, if <tt>true</tt> is
specified to this method, then validation will be successful if
<i>any</i> specified field is filled.
*/
public VFilledOnChoice anyFilled(boolean val)
	{
	anyFilledOK = val;	
	return this;
	}

public boolean preConditionMet(FormData fd, HttpServletRequest req)
	{
	boolean choiceFilled = cg.isFilled(fd);  //filled at all ?
	if (choiceFilled)  //filled with the value we want ?
		{
		Iterator it = cg.getValue(fd).iterator();
		while (it.hasNext())
			{
			ChoiceGroup.Choice c = (ChoiceGroup.Choice) it.next();
			String str = c.getValue();
			if (choiceValue.equals(str)) {
				choiceFilled = true;
				break;
				}
			else {
				choiceFilled = false;
				}
			}
		}
	
	if (onSelect)  //some choice has to be selected first
		{
		if (! choiceFilled) //not selected
 			return false;
		}
	else {	 //choice should not selected by user
		if (choiceFilled) //selected
			return false;
		}
		
	return true;
	}	

public boolean postConditionMet(FormData fd, HttpServletRequest req)
	{
	int count = postFields.size();
	boolean one_filled = false;
	
	for (int n = 0; n < count; n++) 
		{
		Field f = (Field) postFields.get(n);
 		boolean filled = f.isFilled(fd);
 		
 		if (filled)
 			{
 			if (anyFilledOK) 
 				{  	//any filled is a-ok
 				if (dbg) System.out.println(f.name + " is filled, anyfilled=ok, returning true");
 				return true;
 				}
			else{ // ALL have to be filled, keep truckin
				one_filled = true; //latch
			    }
			}
 		
		if (! filled)			  //field is empty
			{
			if (! anyFilledOK)      //no empty field allowed
				{
 				if (dbg) System.out.println(f.name + " is filled, anyfilled=!ok, returning false");
				return false;
				}
			//else {
			//	 //keep truckin
			//	 }
			}
		}
	
	//we made it here, all fields were filled.
	
	if (! one_filled)
		return false;
	
	return true;
	}	

/**
Sets whether validation will occur if the choice is
selected by the user or not. By default, validation
occurs when the choice is selected by the user.

@param	val		<tt>true</tt> to validate only when selected
				<tt>false</tt> otherwise.
*/
public void onSelected(boolean val)
	{
	onSelect = val;
	}

}          //~class ValidatorConditionalFilled

