// Copyright (c) 2001 Hursh Jain (http://www.mollypages.org) 
// The Molly framework is freely distributable under the terms of an
// MIT-style license. For details, see the molly pages web site at:
// http://www.mollypages.org/. Use, modify, have fun !

package fc.web.servlet;

import java.io.*;
import java.util.logging.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;

import fc.io.*;
import fc.web.*;
import fc.util.*;

/** 
Represents an action available to a servlet. 

@author	hursh jain
**/
public abstract class Action
{
protected	final	String		name;

/**
Constructs a new Action and registers it with the specified
{@link ActionMgr}

@param 	name	the name of this action. Action names should be 
				unique within a given {@link ActionMgr}. This is
				the value of the <tt>act</tt> parameter submitted 
				by the web client and is used to dispatch to this
				action.

**/
protected Action(String name) 
	{
	Argcheck.notnull(name, "name param was null");
	this.name = name;
	}

/** 
Subclasses should implement this method to carry out a particular
action
**/
abstract 
public void handle(HttpServletRequest request, HttpServletResponse res) 
throws Exception; 
	
/**  
Returns the name of this action.
**/
public String getName() {
	return name;
	}

public String toString() {
	return getClass().getName() + "; action=" + name;
	}

}          //~class Action
