// Copyright (c) 2001 Hursh Jain (http://www.mollypages.org) 
// The Molly framework is freely distributable under the terms of an
// MIT-style license. For details, see the molly pages web site at:
// http://www.mollypages.org/. Use, modify, have fun !

package fc.web.servlet;

import javax.servlet.*;
import javax.servlet.http.*;
import java.sql.*;
import java.io.*;
import java.util.*;

import fc.io.*;
import fc.jdbc.*;
import fc.web.*;

/** 
Allows tweaking of configuration parameters (such as log levels) at
runtime.
<br>
<b>
This servlet should be configured/deployed to be invokable only from the
localhost or trusted network(s).
</b>
@author hursh jain
*/
public class AdminServlet extends FCBaseServlet 
{
/*IMPL NOTE:
sunchronize stuff that can be tweaked here with ContextInit
*/
public void init(ServletConfig conf) throws ServletException 
	{
	super.init(conf);
	}

public void doGet(HttpServletRequest request, HttpServletResponse response) 
throws ServletException, IOException
	{
	PrintWriter out = response.getWriter();	
	try {
		showSQLForm(request, response);
		}
	catch (SQLException ex) {
		out.print("<pre>");
		ex.printStackTrace(out);
		out.print("</pre>");
		throw new ServletException(ex);
		}
	}
	
public void doPost(HttpServletRequest request, HttpServletResponse response) 
throws ServletException, IOException
	{
	response.setContentType("text/html");
	PrintWriter out = response.getWriter();
	Connection con = null;
	ServletContext context = getServletContext();

	try 
	{	
	//1. Set the default context log
	String loglevel = request.getParameter("log.level");
	//log.bug("----------> context loglevel", loglevel);
	if (loglevel != null && ! loglevel.equals("n/a")) 
		{
		log.bug("Adjusting log level for the application log; new level=", loglevel);
		WebApp.getInstance(appName).getAppLog().setLevel(loglevel);
		}

	//2. set servlet specific log levels
	Map allservlets = WebApp.getInstance(appName).allServletsMap;
	
	Enumeration e = request.getParameterNames();
	while (e.hasMoreElements()) 
		{
		String param_name = (String) e.nextElement();
		if (param_name.startsWith("servlet.log."))
			{
			loglevel = request.getParameter(param_name);
			if (loglevel != null && ! loglevel.equals("n/a")) 
				{
				log.bug("Adjusting log level for: ", param_name, "; new level=", loglevel);
				String log_name = param_name.substring(12, param_name.length()); //"servlet.log.X",X=12
				FCBaseServlet servlet = (FCBaseServlet) allservlets.get(log_name);
				if (servlet == null) {
					log.bug("Error setting new level for", param_name, "; log not found in all_logs map");
					}
				else {
					Log log = servlet.getLog();
					log.setLevel(loglevel);
					}
				}
			}		
		} //~while
	showSQLForm(request, response);
	} //~try
	catch (SQLException ex) {
		out.print("<pre>");
		ex.printStackTrace(out);
		out.print("</pre>");
		throw new ServletException(ex);
		}
	}  //~doPost


void showSQLForm(HttpServletRequest request, HttpServletResponse response) 
throws ServletException, IOException, SQLException
	{
	ServletContext context = getServletContext();

	//we need to calculate this on the fly because the servlet may
	//be invoked via some deployment specific servlet mapping name
	String actionURL = request.getServletPath();
	
	response.setContentType("text/html");
	PrintWriter out = response.getWriter();
	out.println("<html><head></head><body bgcolor='#FFFFFF'><center>");

	out.print("<form method=post action=" + actionURL + ">");

	out.println("<h1>Admin Servlet</h1><hr>");

	//CONNECTION MANAGER
	out.println("<h3>Installed Connection Managers Information</h3>");
	out.println(WebApp.getInstance(appName).connectionManagers);
	out.println("<hr>");
	out.println("Default Connection Manager");
	out.println(WebApp.getInstance(appName).getConnectionMgr());
	out.println("<hr>");

	//LOGGERS
	out.println("<h3>Current Logging Information</h3>");
	out.println("<table border=1>");
	out.println("<tr bgcolor=#cdcdcd><td width=50%><b>Context/Default log</b></td><td>Current Level</td><td>Select a new level</td></tr>");

	Log defaultlog = 	WebApp.getInstance(appName).getAppLog();
	out.println("<tr><td>");
	out.println("This is the default log used by the fc framework and by the ServletContext (and stored in the context under the <tt>ContextInit.DEFAULT_LOG_KEY</tt> key)");
	out.println("</td><td>");
	out.println(defaultlog.getLevel());
	out.println("</td><td>");
	printLogSelect(out, "defaultlog");
	out.println("</td></tr>");

	out.println("<tr><td colspan=3>&nbsp</td></tr>");
	out.println("<tr bgcolor=#cdcdcd><td><b>Per Servlet/JSP logs</b></td><td>Current Level</td><td>Select a new level</td></tr>");

	Map allservlets = WebApp.getInstance(appName).allServletsMap;
	Iterator it = allservlets.entrySet().iterator();
	while (it.hasNext()) 
		{
		Map.Entry entry = (Map.Entry) it.next();
		FCBaseServlet servlet = (FCBaseServlet) entry.getValue();
		Log log = servlet.getLog();
		out.print("<tr><td>[<font color=blue>");
		out.print(servlet);
		out.print("</font>]<br>");
		out.print(servlet.stats());
		out.print("</td><td>");
		out.print(log.getLevel());
		out.print("</td><td>");
		printLogSelect(out, 
				"servlet.log." + servlet.getClass().getName());
		out.println("</td></tr>");
		}
	out.println("</table>");
	out.println("<hr>");
	
	//FORM END
	out.print("<INPUT TYPE=submit name=submit value=submit></INPUT>");
	out.print("</form></center></body></html>");
	out.flush();
	}

void printLogSelect(PrintWriter out, Object selectname)
	{
	out.print("<select name='");
	out.print(selectname);
	out.print("'>");
	out.println("<option value='n/a'>--[select]--</option>");
	Iterator it = log.getLevelNames();
	while (it.hasNext()) {
		Object level_name = it.next();
		out.print("<option value='");
		out.print(level_name);
		out.print("'>");
		out.print(level_name);
		out.println("</option>");
		}
	out.println("</select>");
	}

}
