// Copyright (c) 2001 Hursh Jain (http://www.mollypages.org) 
// The Molly framework is freely distributable under the terms of an
// MIT-style license. For details, see the molly pages web site at:
// http://www.mollypages.org/. Use, modify, have fun !

package fc.web.servlet;

import java.io.*;
import java.net.*;
import java.sql.*;
import javax.servlet.*;
import javax.servlet.http.*;

import java.util.*;

import fc.io.*;
import fc.jdbc.*;
import fc.web.*;
import fc.util.*;

/** 
Implements a simple jdbc based authentication filter. Uses {@link
JDBCSession} to check for the valid existence of the session ID. The
session ID itself is expected to be inside a cookie (the presence of a
cookie is checked by invoking {@link LoginServlet#getSIDCookie}
<p>
Uses the default database as specified in web.xml and requires
{@link JDBCSession} to work against that database.

@author hursh jain
**/
public class JDBCAuthFilter extends AuthFilter 
{
private final 	static boolean  		dbg = false;
private 		static ConnectionMgr 	cmgr;
private 		static JDBCSession 		session;

public void init(FilterConfig config) throws ServletException 
	{
	super.init(config);
	
	//We use the default connection manager. If need be, this can
	//be changed so that we use the connection manager to a property
	//file specified database instead.
	
	cmgr = WebApp.getInstance(appName).getConnectionMgr();
	session = JDBCSession.getInstance();
	}

/**
Checks to see if the session id (<tt>sid</tt>) exists in the cookie and it that
points to a valid (non-expired) database session.
*/
public boolean isUserLoggedIn(HttpServletRequest req, HttpServletResponse res)
throws SQLException
	{
	Cookie c = LoginServlet.getSIDCookie(req);
	if (c == null) 
		return false;

	boolean loggedin = false;
	Connection con = null;

	try {
		con = cmgr.getConnection();
		loggedin = session.exists(con, c.getValue());
		if (dbg) System.out.println("JDBCAuthFilter.isUserLoggedIn(): (2) sid points to valid session=" + loggedin);
		}
	finally {
		con.close();
		}
	
	return loggedin;
	}
			
} //~class JDBCAuthFilter

