// Copyright (c) 2001 Hursh Jain (http://www.mollypages.org) 
// The Molly framework is freely distributable under the terms of an
// MIT-style license. For details, see the molly pages web site at:
// http://www.mollypages.org/. Use, modify, have fun !

package fc.web.servlet;

import javax.servlet.*;
import javax.servlet.http.*;
import java.sql.*;
import java.io.*;
import java.util.*;

import fc.io.*;
import fc.jdbc.*;
import fc.web.*;

/** 
Raw SQL query servlet. Useful to test for and do manual SQL
queries from a web page. Uses the {@link ConnectionMgr}
currently installed in the {@link fc.web.WebApp}
<br>
XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX 
DOES NO AUTHENTICATION, for TESTING only. 
EXTREMELY dangerous to your data if used by an attacker.
XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXxXXXX
<p>
ONLY install/use this servlet in a DEVELOPMENT environment.
Since this servlet can be invoked as <tt>
/servlet/fc.web.RawSQLServlet </tt>, and since it's often
desirable to keep the <tt>/servlet</tt> mapping, this
servlet expects another servlet init parameter called
<tt>enable</tt>. This servlet will only run if this
parameter is present and it's value is the string
<tt>true</tt>.

@author hursh jain
*/
public class RawSQLServlet extends FCBaseServlet 
{
public void init(ServletConfig conf) throws ServletException 
	{
	super.init(conf);

	String enable = WebUtil.getRequiredParam(this, "enable");
	if (! enable.equalsIgnoreCase("true")) {
		throw new UnavailableException("Cannot run RawSQLServlet because the 'enable' init paramter was not set to true");
		}
	}

public void doGet(HttpServletRequest request, HttpServletResponse response) 
throws ServletException, IOException
	{
	PrintWriter out = response.getWriter();
	
	try {
		showSQLForm(request, response);
		}
	catch (SQLException ex) {
		out.print("<B> SQL Error:</B>\n" + ex);
		out.print("<pre>");
		ex.printStackTrace(out);
		out.print("</pre>");
		throw new ServletException(ex);
		}
	}
	
public void doPost(HttpServletRequest request, HttpServletResponse response) 
throws ServletException, IOException
	{
	response.setContentType("text/html");
	PrintWriter out = response.getWriter();
	Connection con = null;
	try {	
		String query = request.getParameter("sql");
		if (query == null) {
			showSQLForm(request, response);
			return;
			}
				
		if (query == null) {
			out.println("<b>Error: malformed query, contact administrator</b>");
			return;
			}

		long startTime = System.currentTimeMillis(); 
		con = getConnection();
		Statement stmt = con.createStatement();

		out.println("<html><head>");

		//style used by queryutil.printrsashtmltable		
		out.println("<style type=\"text/css\">");
		out.println(".QueryUtil_Table { padding: 2px; border: 1px solid #660000; }");
		out.println(".QueryUtil_HeaderCell { border: 1px solid; background: red; }");
		out.println(".QueryUtil_Cell { border: 1px solid; }");
		out.println("</style>");

		out.println("</head><body bgcolor='#FFFFFF'><center>");
		out.print("<h2>Query</h2><blockquote><pre>");
		out.print(query);
		out.println("</pre></blockquote>");
	
		ResultSet rs = stmt.executeQuery(query);
		long querytime = System.currentTimeMillis() - startTime;
		
		out.println("<p><h2>Results</h2>");

		QueryUtil.printResultSetHTMLTable(rs, out, 
			QueryUtil.ResultSetPrintDirection.HORIZONTAL);

     	out.println("<hr>");
     	out.print("Query time: ");
     	//out.println("<br>" + querytime);
     	out.println(formatTime(querytime));
     	out.println("<hr>");
    	
    	printConInfo(out, con);
    	
    	out.println("</body></html>");
		} 
	catch (SQLException ex) {
		out.print("<B> SQL Error:</B>\n" + ex);
		out.print("<pre>");
		ex.printStackTrace(out);
		out.print("</pre>");
		throw new ServletException(ex);
		}
	finally {
		QueryUtil.close(null, null, con);
		}
	}  //~doPost


void showSQLForm(HttpServletRequest request, HttpServletResponse response) 
throws ServletException, IOException, SQLException
	{
	//we need to calculate this on the fly because the servlet may
	//be invoked via some deployment specific servlet mapping name
	String actionURL = request.getServletPath();
	
	response.setContentType("text/html");
	PrintWriter out = response.getWriter();
	out.println("<html><head></head><body bgcolor='#FFFFFF'><center>");
	out.println("<h1>Raw SQL Servlet</h1><hr>");
	out.println("<h2>Connection Information</h2>");
	printJDBCInfo(out);
	out.println("<h2>Enter a SQL Query</h2><hr>");
	out.print("<form method=post action=" + actionURL + ">");
	out.print("<textarea rows=10 cols=50 name=sql>");
	out.print("</textarea><br>");
	out.print("<INPUT TYPE=submit name=submit value=submit></INPUT>");
	out.print("</form></center></body></html>");
	out.flush();
	}

void printJDBCInfo(PrintWriter out) throws SQLException 
	{
	Connection con = null;
	
	try {
		con = getConnection();
		out.println("<table border=1 bordercolor=#3f6c96 cellpadding=4 cellspacing=0>");
	
		//driver etc
		out.println("<tr><td align=right>");
		out.println("Driver ");
		out.println("</td>");
		out.println("<td align=left>");
		out.println(WebApp.getInstance(appName).getConnectionMgr().getDriver());	
		out.println("</td></tr>");	
		
		//catalog
		out.println("<tr><td align=right>");
		out.println("Catalog ");
		out.println("</td>");
		out.println("<td align=left>");
		out.println(con.getCatalog());	
		out.println("</td></tr>");	
	
		//autocommit
		out.println("<tr><td align=right>");
		out.println("Autocommit ");
		out.println("</td>");
		out.println("<td align=left>");
		out.println(con.getAutoCommit());	
		out.println("</td></tr>");	
	
		//transaction-isolation
		out.println("<tr><td align=right>");
		out.println("Transaction isolation ");
		out.println("</td>");
		out.println("<td align=left>");
		out.println(con.getTransactionIsolation());	
		out.println("</td></tr>");	
		
		out.println("</table>");
		}
	finally {
		QueryUtil.close(null, null, con);
		}	
	}


void printConInfo(PrintWriter out, Connection con) throws SQLException 
	{
	out.println("<table border=0>");

	SQLWarning warning = con.getWarnings();

	//SQL Warnings
	out.println("<tr><td align=right>");
	out.println("SQL Warnings: ");
	out.println("</td>");

	out.println("<td align=left>");
	if (warning == null) {
		out.println("None");	
		}
	else {
		out.println(warning);
		while (warning.getNextWarning() != null) 
			{
			out.println("<br>");
			out.println(warning);
			}
		}
	out.println("</td></tr>");	
	out.println("</table>");
	}

String formatTime(long time) 
	{
	if (time < 1000)
		return time + " ms";
	else
		return (time % 1000) + " seconds";
	}

}
